using DG.Tweening;
using UnityEngine;

[RequireComponent(typeof(CanvasGroup))]
public class Fade : MonoBehaviour
{
    public float FadeDuration = .4f;
    CanvasGroup _canvasGroup;

    public virtual void Start()
    {
        _canvasGroup = GetComponent<CanvasGroup>();
    }
    public void FadeIn(string sceneName)
    {
        _canvasGroup.DOFade(1, FadeDuration).OnComplete( () =>{ MakeThing(sceneName); _canvasGroup.blocksRaycasts = true; });
    }
    public void FadeOut()
    {
        _canvasGroup.DOFade(0, FadeDuration).OnComplete(() => _canvasGroup.blocksRaycasts = false);
    }
    public virtual void MakeThing(string sceneName)
    {

    }

    private void OnDestroy()
    {
        DOTween.Kill(_canvasGroup);
    }
}
